/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.core.model.GitIndexRefreshJob;
import com.aptana.git.core.model.GitRef;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.Messages;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitIndex {
    private static final String ADD_STATUS = "A";
    private static final String DELETED_STATUS = "D";
    private static final String UNMERGED_STATUS = "U";
    private static final String NULL_DELIMITER = "\u0000";
    private static final String[] BINARY_EXTENSIONS = new String[]{"pdf", "jpg", "jpeg", "png", "bmp", "gif", "o", "class", "zip", "gz", "tar", "ico", "so", "jar", "exe", "7z", "app", "apk", "ipa", "war"};
    private GitRepository repository;
    List<ChangedFile> changedFiles;
    private Object changedFilesLock = new Object();
    private boolean notify;
    private ExecutorService es;
    private GitIndexRefreshJob refreshJob;

    GitIndex(GitRepository repository) {
        Assert.isNotNull((Object)repository, (String)"GitIndex requires a repository");
        this.repository = repository;
        this.refreshJob = new GitIndexRefreshJob(this);
        this.es = Executors.newFixedThreadPool(3);
    }

    synchronized void scheduleBatchRefresh() {
        if (this.refreshJob != null) {
            this.refreshJob.refreshAll();
        }
    }

    public IStatus refresh(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IStatus iStatus = this.refresh(true, null, (IProgressMonitor)sub.newChild(100));
            return iStatus;
        }
        finally {
            sub.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IStatus refresh(boolean notify, Collection<IPath> filePaths, IProgressMonitor monitor) {
        ArrayList<ChangedFile> preRefresh;
        IStatus result;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.notify = notify;
        GitIndex gitIndex = this;
        synchronized (gitIndex) {
            this.repository.forceWrite();
            result = GitExecutable.instance().runInBackground(this.repository.workingDirectory(), "update-index", "-q", "--unmerged", "--ignore-missing", "--refresh");
            this.repository.exitWriteProcess();
        }
        if (result == null) {
            return new Status(4, GitPlugin.getPluginId(), "Failed to execute git update-index");
        }
        if (!result.isOK()) {
            IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (String)("Unable to run update-index: " + result.getMessage()));
            return result;
        }
        final HashSet portablePathStrings = new HashSet(CollectionsUtil.map(filePaths, (IMap)new IMap<IPath, String>(){

            public String map(IPath item) {
                return item.toPortableString();
            }
        }));
        HashSet<FilesRefreshJob> jobs = new HashSet<FilesRefreshJob>(3);
        jobs.add(new UntrackedFilesRefreshJob(this, portablePathStrings));
        jobs.add(new UnstagedFilesRefreshJob(this, portablePathStrings));
        jobs.add(new StagedFilesRefreshJob(this, portablePathStrings));
        if (monitor != null && monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        HashMap<IPath, ChangedFile> newChangedFiles = new HashMap<IPath, ChangedFile>();
        MultiStatus errors = new MultiStatus("com.aptana.git.core", 1, "Errors occurred while grabbing changed file listings", null);
        try {
            if (this.es.isShutdown()) {
                return Status.CANCEL_STATUS;
            }
            List futures = this.es.invokeAll(jobs);
            for (Future future : futures) {
                while (!future.isDone()) {
                    if (monitor != null && monitor.isCanceled()) {
                        future.cancel(true);
                    }
                    Thread.yield();
                }
                try {
                    Map map = (Map)future.get();
                    if (newChangedFiles.isEmpty()) {
                        newChangedFiles.putAll(map);
                        continue;
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        IPath path = (IPath)entry.getKey();
                        ChangedFile file = (ChangedFile)entry.getValue();
                        if (newChangedFiles.containsKey(path)) {
                            newChangedFiles.put(path, file.merge((ChangedFile)newChangedFiles.get(path)));
                            continue;
                        }
                        newChangedFiles.put(path, file);
                    }
                }
                catch (CancellationException map) {
                }
                catch (ExecutionException e) {
                    Throwable t = e.getCause();
                    if (t instanceof CoreException) {
                        errors.merge(((CoreException)t).getStatus());
                        continue;
                    }
                    errors.merge((IStatus)new Status(4, "com.aptana.git.core", t.getMessage(), t));
                }
            }
        }
        catch (InterruptedException e) {
            IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (Throwable)e);
        }
        Object object = this.changedFilesLock;
        synchronized (object) {
            if (this.changedFiles != null) {
                preRefresh = new ArrayList(this.changedFiles.size());
                for (ChangedFile file : this.changedFiles) {
                    preRefresh.add(file.clone());
                }
            } else {
                preRefresh = new ArrayList<ChangedFile>(0);
            }
            this.changedFiles = CollectionsUtil.isEmpty(filePaths) ? new ArrayList<ChangedFile>() : CollectionsUtil.filter(this.changedFiles, (IFilter)new IFilter<ChangedFile>(){

                public boolean include(ChangedFile item) {
                    return !portablePathStrings.contains(item.getRelativePath().toPortableString());
                }
            });
            if (!CollectionsUtil.isEmpty(newChangedFiles)) {
                this.changedFiles.addAll(newChangedFiles.values());
            }
        }
        newChangedFiles = null;
        this.postIndexChange(preRefresh, this.changedFiles);
        sub.done();
        if (!errors.isOK()) {
            return errors;
        }
        return Status.OK_STATUS;
    }

    private void postIndexChange(Collection<ChangedFile> preChangeFiles, Collection<ChangedFile> postChangeFiles) {
        if (this.notify) {
            this.repository.fireIndexChangeEvent(preChangeFiles, postChangeFiles);
        } else {
            this.notify = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangedFile> changedFiles() {
        IStatus status;
        boolean isNull = false;
        Object object = this.changedFilesLock;
        synchronized (object) {
            isNull = this.changedFiles == null;
        }
        if (isNull && !(status = this.refresh(false, null, (IProgressMonitor)new NullProgressMonitor())).isOK()) {
            IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (String)status.getMessage());
            return Collections.emptyList();
        }
        object = this.changedFilesLock;
        synchronized (object) {
            if (this.changedFiles == null) {
                return Collections.emptyList();
            }
            ArrayList<ChangedFile> copy = new ArrayList<ChangedFile>(this.changedFiles.size());
            for (ChangedFile file : this.changedFiles) {
                copy.add(file.clone());
            }
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus stageFiles(Collection<ChangedFile> stageFiles) {
        if (CollectionsUtil.isEmpty(stageFiles)) {
            return Status.OK_STATUS;
        }
        StringBuffer input = new StringBuffer(stageFiles.size() * stageFiles.iterator().next().getRelativePath().toPortableString().length());
        for (ChangedFile file : stageFiles) {
            input.append(file.getRelativePath()).append('\n');
        }
        IStatus result = this.repository.executeWithInput(input.toString(), "update-index", "--add", "--remove", "--stdin");
        if (result == null) {
            return new Status(4, "com.aptana.git.core", "Failed to stage files. Process failed to run.");
        }
        if (!result.isOK()) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (String)MessageFormat.format("Failed to stage files: {0}", result.getMessage()), (String)"com.aptana.git.core/debug");
            return result;
        }
        ArrayList<ChangedFile> preFiles = new ArrayList<ChangedFile>(stageFiles.size());
        for (ChangedFile file : stageFiles) {
            preFiles.add(file.clone());
            Object object = this.changedFilesLock;
            synchronized (object) {
                int index;
                if (this.changedFiles != null && (index = Collections.binarySearch(this.changedFiles, file)) >= 0) {
                    ChangedFile orig = this.changedFiles.get(index);
                    orig.makeStaged();
                }
            }
            file.makeStaged();
        }
        preFiles.trimToSize();
        this.postIndexChange(preFiles, stageFiles);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus unstageFiles(Collection<ChangedFile> unstageFiles) {
        if (CollectionsUtil.isEmpty(unstageFiles)) {
            return Status.OK_STATUS;
        }
        StringBuilder input = new StringBuilder();
        for (ChangedFile file : unstageFiles) {
            input.append(file.indexInfo());
        }
        IStatus result = this.repository.executeWithInput(input.toString(), "update-index", "-z", "--index-info");
        if (result == null) {
            return new Status(4, "com.aptana.git.core", "Failed to unstage files. Process failed to run.");
        }
        if (!result.isOK()) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (String)MessageFormat.format("Failed to stage files: {0}", result.getMessage()), (String)"com.aptana.git.core/debug");
            return result;
        }
        ArrayList<ChangedFile> preFiles = new ArrayList<ChangedFile>(unstageFiles.size());
        for (ChangedFile file : unstageFiles) {
            preFiles.add(file.clone());
            Object object = this.changedFilesLock;
            synchronized (object) {
                int index;
                if (this.changedFiles != null && (index = Collections.binarySearch(this.changedFiles, file)) >= 0) {
                    ChangedFile orig = this.changedFiles.get(index);
                    orig.makeUnstaged();
                }
            }
            file.makeUnstaged();
        }
        preFiles.trimToSize();
        this.postIndexChange(preFiles, unstageFiles);
        return result;
    }

    public IStatus discardChangesForFiles(Collection<ChangedFile> discardFiles) {
        StringBuilder input = new StringBuilder();
        for (ChangedFile file : discardFiles) {
            input.append(file.getRelativePath().toPortableString()).append(NULL_DELIMITER);
        }
        IStatus result = this.repository.executeWithInput(input.toString(), "checkout-index", "--index", "--quiet", "--force", "-z", "--stdin");
        if (result == null) {
            return new Status(4, "com.aptana.git.core", "Failed to revert files. Process failed to run.");
        }
        if (!result.isOK()) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (String)MessageFormat.format("Failed to revert files: {0}", result.getMessage()), (String)"com.aptana.git.core/debug");
            return result;
        }
        ArrayList<ChangedFile> preFiles = new ArrayList<ChangedFile>(discardFiles.size());
        for (ChangedFile file : discardFiles) {
            preFiles.add(file.clone());
            file.setUnstaged(false);
        }
        preFiles.trimToSize();
        this.postIndexChange(preFiles, discardFiles);
        return result;
    }

    public IStatus commit(String commitMessage) {
        IStatus status = this.doCommit(commitMessage);
        if (status.isOK()) {
            this.repository.hasChanged();
        }
        this.refresh((IProgressMonitor)new NullProgressMonitor());
        return status;
    }

    private IStatus doCommit(String commitMessage) {
        if ("win32".equals(Platform.getOS())) {
            commitMessage = commitMessage.replace("\"", "\\\"");
        }
        return this.repository.execute(GitRepository.ReadWrite.WRITE, this.repository.workingDirectory(), ShellExecutable.getEnvironment((IPath)this.repository.workingDirectory()), "commit", "-m", commitMessage);
    }

    String[] commitsBetween(String sha1, String sha2) {
        if (sha1.startsWith("refs/")) {
            sha1 = this.repository.toSHA(GitRef.refFromString(sha1));
        }
        if (sha2.startsWith("refs/")) {
            sha2 = this.repository.toSHA(GitRef.refFromString(sha2));
        }
        if (sha1.equals(sha2)) {
            return ArrayUtil.NO_STRINGS;
        }
        IStatus status = this.repository.execute(GitRepository.ReadWrite.READ, "log", "--pretty=format:\"%s\"", String.valueOf(sha1) + ".." + sha2);
        if (status == null || !status.isOK() || status.getMessage().trim().length() == 0) {
            return ArrayUtil.NO_STRINGS;
        }
        return status.getMessage().split("[\r\n]+");
    }

    public String diffForFile(ChangedFile file, boolean staged, int contextLines) {
        if (this.hasBinaryAttributes(file)) {
            return Messages.GitIndex_BinaryDiff_Message;
        }
        String parameter = "-U" + contextLines;
        if (staged) {
            String indexPath = ":0:" + file.getRelativePath().toPortableString();
            if (file.status == ChangedFile.Status.NEW) {
                IStatus status = this.repository.execute(GitRepository.ReadWrite.READ, "show", indexPath);
                return status.getMessage();
            }
            IStatus result = this.repository.execute(GitRepository.ReadWrite.READ, "diff-index", parameter, "--cached", "HEAD", "--", file.getRelativePath().toPortableString());
            if (result == null || !result.isOK()) {
                return null;
            }
            return result.getMessage();
        }
        if (file.status == ChangedFile.Status.NEW) {
            try {
                return IOUtil.read((InputStream)new FileInputStream(this.workingDirectory().append(file.getRelativePath().toPortableString()).toFile()), (String)"UTF-8");
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        IStatus result = this.repository.execute(GitRepository.ReadWrite.READ, "diff-files", parameter, "--", file.getRelativePath().toPortableString());
        return result.getMessage();
    }

    public boolean hasBinaryAttributes(ChangedFile file) {
        String fileExtension;
        IStatus result = this.repository.execute(GitRepository.ReadWrite.READ, "check-attr", "binary", file.getRelativePath().toPortableString());
        String output = result.getMessage();
        if ((output = output.trim()).endsWith("binary: set")) {
            return true;
        }
        if (output.endsWith("binary: unset")) {
            return false;
        }
        if (output.endsWith("binary: unspecified") && (fileExtension = file.getRelativePath().getFileExtension()) != null) {
            String[] stringArray = BINARY_EXTENSIONS;
            int n = BINARY_EXTENSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (fileExtension.equalsIgnoreCase(extension)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean resourceOrChildHasChanges(IResource resource) {
        List<ChangedFile> changedFiles = this.changedFiles();
        if (CollectionsUtil.isEmpty(changedFiles)) {
            return false;
        }
        IPath workingDirectory = this.repository.workingDirectory();
        IPath resourcePath = resource.getLocation();
        for (ChangedFile changedFile : changedFiles) {
            IPath fullPath = workingDirectory.append(changedFile.getRelativePath()).makeAbsolute();
            if (!resourcePath.isPrefixOf(fullPath)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return !this.changedFiles().isEmpty();
    }

    protected boolean hasUnresolvedMergeConflicts() {
        List<ChangedFile> changedFiles = this.changedFiles();
        if (CollectionsUtil.isEmpty(changedFiles)) {
            return false;
        }
        for (ChangedFile changedFile : changedFiles) {
            if (!changedFile.hasUnmergedChanges() || !changedFile.hasUnstagedChanges()) continue;
            return true;
        }
        return false;
    }

    public Set<IResource> getChangedResources() {
        HashSet<IResource> resources = new HashSet<IResource>();
        List<ChangedFile> changedFiles = this.changedFiles();
        if (!CollectionsUtil.isEmpty(changedFiles)) {
            for (ChangedFile changedFile : changedFiles) {
                IFile resource = this.getResourceForChangedFile(changedFile);
                if (resource == null) continue;
                resources.add((IResource)resource);
            }
        }
        return resources;
    }

    IFile getResourceForChangedFile(ChangedFile changedFile) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(this.workingDirectory().append(changedFile.getRelativePath()));
    }

    protected ChangedFile getChangedFileForResource(IResource resource) {
        if (resource == null || resource.getLocationURI() == null) {
            return null;
        }
        IPath resourcePath = resource.getLocation();
        List<ChangedFile> changedFiles = this.changedFiles();
        if (!CollectionsUtil.isEmpty(changedFiles)) {
            for (ChangedFile changedFile : changedFiles) {
                IPath fullPath = this.workingDirectory().append(changedFile.getRelativePath());
                if (!resourcePath.equals((Object)fullPath)) continue;
                return changedFile;
            }
        }
        return null;
    }

    private IPath workingDirectory() {
        return this.repository.workingDirectory();
    }

    protected List<ChangedFile> getChangedFilesForContainer(IContainer container) {
        if (container == null || container.getLocationURI() == null) {
            return Collections.emptyList();
        }
        List<ChangedFile> changedFiles = this.changedFiles();
        if (CollectionsUtil.isEmpty(changedFiles)) {
            return Collections.emptyList();
        }
        IPath resourcePath = container.getLocation();
        ArrayList<ChangedFile> filtered = new ArrayList<ChangedFile>();
        IPath workingDirectory = this.repository.workingDirectory();
        for (ChangedFile changedFile : changedFiles) {
            IPath fullPath = workingDirectory.append(changedFile.getRelativePath()).makeAbsolute();
            if (!resourcePath.isPrefixOf(fullPath)) continue;
            filtered.add(changedFile);
        }
        return filtered;
    }

    public void refreshAsync(Collection<IPath> paths) {
        if (this.refreshJob != null) {
            this.refreshJob.refresh(paths);
        }
    }

    void dispose() {
        IJobManager jobManager;
        if (this.es != null) {
            try {
                this.es.awaitTermination(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.es.shutdown();
        }
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
            this.refreshJob = null;
        }
        if ((jobManager = Job.getJobManager()) != null) {
            jobManager.cancel((Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class FilesRefreshJob
    implements Callable<Map<IPath, ChangedFile>> {
        protected GitRepository repo;
        protected GitIndex index;
        protected Set<String> filePaths;

        private FilesRefreshJob(GitIndex index, Set<String> filePaths) {
            this.index = index;
            this.repo = index.repository;
            this.filePaths = filePaths;
        }

        protected List<String> linesFromNotification(String string) {
            if (string == null) {
                return Collections.emptyList();
            }
            if (string.endsWith(GitIndex.NULL_DELIMITER)) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() == 0) {
                return Collections.emptyList();
            }
            return StringUtil.tokenize((String)string, (String)GitIndex.NULL_DELIMITER);
        }

        protected Map<IPath, List<String>> dictionaryForLines(List<String> lines) {
            HashMap<IPath, List<String>> dictionary = new HashMap<IPath, List<String>>(lines.size() / 2);
            Assert.isTrue((lines.size() % 2 == 0 ? 1 : 0) != 0, (String)("Must have an even number of lines: " + lines));
            Iterator<String> iter = lines.iterator();
            while (iter.hasNext()) {
                String fileStatus = iter.next();
                String fileName = iter.next();
                dictionary.put(Path.fromPortableString((String)fileName), StringUtil.tokenize((String)fileStatus, (String)" "));
            }
            return dictionary;
        }

        protected Map<IPath, ChangedFile> addFilesFromDictionary(Map<IPath, List<String>> dictionary, boolean staged, boolean tracked) {
            if (dictionary == null || dictionary.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<IPath, ChangedFile> result = new HashMap<IPath, ChangedFile>(dictionary.size());
            for (Map.Entry<IPath, List<String>> entry : dictionary.entrySet()) {
                IPath path = entry.getKey();
                if (path.isAbsolute()) {
                    IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (String)MessageFormat.format("Found an entry for an absoolute path ({0}), won't add to our changed file listing for repo at {1}", path.toOSString(), GitIndex.this.workingDirectory().toOSString()));
                    continue;
                }
                List<String> fileStatus = entry.getValue();
                ChangedFile.Status status = ChangedFile.Status.MODIFIED;
                status = fileStatus.get(4).equals(GitIndex.DELETED_STATUS) ? ChangedFile.Status.DELETED : (fileStatus.get(4).equals(GitIndex.UNMERGED_STATUS) ? ChangedFile.Status.UNMERGED : (fileStatus.get(0).equals(":000000") ? ChangedFile.Status.NEW : ChangedFile.Status.MODIFIED));
                String mode = null;
                String sha = null;
                if (tracked) {
                    mode = fileStatus.get(0).substring(1);
                    sha = fileStatus.get(2);
                }
                result.put(path, new ChangedFile(GitIndex.this.repository, path, status, mode, sha, staged, !staged));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StagedFilesRefreshJob
    extends FilesRefreshJob {
        private StagedFilesRefreshJob(GitIndex index, Set<String> filePaths) {
            super(index, filePaths);
        }

        @Override
        public Map<IPath, ChangedFile> call() throws Exception {
            IStatus result;
            List args = CollectionsUtil.newList((Object[])new String[]{"diff-index", "--cached", "-z", "HEAD"});
            if (!CollectionsUtil.isEmpty((Collection)this.filePaths)) {
                args.add("--");
                args.addAll(this.filePaths);
            }
            if ((result = this.repo.execute(GitRepository.ReadWrite.READ, args.toArray(new String[args.size()]))) != null && result.isOK()) {
                return this.readStagedFiles(result.getMessage());
            }
            if (result != null && result.getCode() == 128 && result.getMessage().startsWith("fatal: ambiguous argument 'HEAD': unknown revision or path not in the working tree")) {
                return Collections.emptyMap();
            }
            throw new CoreException(result);
        }

        private Map<IPath, ChangedFile> readStagedFiles(String string) {
            List<String> lines = this.linesFromNotification(string);
            Map<IPath, List<String>> dic = this.dictionaryForLines(lines);
            return this.addFilesFromDictionary(dic, true, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnstagedFilesRefreshJob
    extends FilesRefreshJob {
        private UnstagedFilesRefreshJob(GitIndex index, Set<String> filePaths) {
            super(index, filePaths);
        }

        @Override
        public Map<IPath, ChangedFile> call() throws Exception {
            IStatus result;
            List args = CollectionsUtil.newList((Object[])new String[]{"diff-files", "-z"});
            if (!CollectionsUtil.isEmpty((Collection)this.filePaths)) {
                args.add("--");
                args.addAll(this.filePaths);
            }
            if ((result = this.repo.execute(GitRepository.ReadWrite.READ, args.toArray(new String[args.size()]))) != null && result.isOK()) {
                return this.readUnstagedFiles(result.getMessage());
            }
            throw new CoreException(result);
        }

        private Map<IPath, ChangedFile> readUnstagedFiles(String string) {
            List<String> lines = this.linesFromNotification(string);
            Map<IPath, List<String>> dic = this.dictionaryForLines(lines);
            return this.addFilesFromDictionary(dic, false, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UntrackedFilesRefreshJob
    extends FilesRefreshJob {
        private UntrackedFilesRefreshJob(GitIndex index, Set<String> filePaths) {
            super(index, filePaths);
        }

        @Override
        public Map<IPath, ChangedFile> call() throws Exception {
            IStatus result;
            List args = CollectionsUtil.newList((Object[])new String[]{"ls-files", "--others", "--exclude-standard", "-z"});
            if (!CollectionsUtil.isEmpty((Collection)this.filePaths)) {
                args.add("--");
                args.addAll(this.filePaths);
            }
            if ((result = this.repo.execute(GitRepository.ReadWrite.READ, args.toArray(new String[args.size()]))) != null && result.isOK()) {
                return this.readOtherFiles(result.getMessage());
            }
            throw new CoreException(result);
        }

        private Map<IPath, ChangedFile> readOtherFiles(String string) {
            List<String> lines = this.linesFromNotification(string);
            HashMap<IPath, List<String>> dictionary = new HashMap<IPath, List<String>>(lines.size());
            List fileStatus = CollectionsUtil.newList((Object[])new String[]{":000000", "100644", "0000000000000000000000000000000000000000", "0000000000000000000000000000000000000000", GitIndex.ADD_STATUS, null});
            for (String path : lines) {
                if (path.length() == 0) continue;
                dictionary.put(Path.fromPortableString((String)path), fileStatus);
            }
            return this.addFilesFromDictionary(dictionary, false, false);
        }
    }
}

